Attribute VB_Name = "Modul"
Option Explicit

Type MSK_Type
    MSK As String * 20
End Type

Type EXT_Type
    EXTDatei As String * 80
End Type

Type ETK_Type
    Text As String * 50
    ObjektTyp As Integer
    X As Single
    Y As Single
    x2 As Single
    y2 As Single
    FontSize As Single
    FontBold As Integer
    FontItalic As Integer
    FontUnderline As Integer
    FontGrad As Integer
    FontAusrichtung As Integer
    FontColor As Single
    FontName As String * 25
End Type

Type ETK_Format
    Bez As String * 50
    BHhe As Single
    BBreite As Single
    BLinks As Single
    BOben As Single
    EHhe As Single
    EBreite As Single
    StckX As Integer
    StckY As Integer
    AbstX As Single
    AbstY As Single
    ERandL As Single
    ERandR As Single
    ERandO As Single
    ERandU As Single
End Type

Type BUS_Format
    Bez As String * 30
    Hhe As Single
    Breite As Single
    RandL As Single
    RandR As Single
    RandO As Single
    RandU As Single
End Type

Type LIS_Format
    Hhe As Single
    Breite As Single
    Top As Single
    Bottom As Single
    Left As Single
    Right As Single
    Spalte As Single
    Inhalt As String * 20
End Type

Type SQL_Format
    Zeile As String * 80
End Type

Public ext As EXT_Type
Public MSK As MSK_Type
Public ETKFormat As ETK_Format
Public BUSFormat As BUS_Format
Public ETK As ETK_Type
Public LIS As LIS_Format

Private free As Integer

Public FSize As Single 'Adressenliste
Public FName As String 'Adressenliste
Public HLinie As Boolean 'Adressenliste
Public VLinie As Boolean 'Adressenliste

Public CancelOP As Integer
Public DatabasePath As String
Public SQLQuery As String
Public SortAdress As String
Public SortBV As String
Public StdMaske As String
Public a As Integer
Public AdrLFNR As Long
Public Sort As String

Public xanf, yanf, xend, yend As Single
Public HORZSIZE As Single
Public VERTSIZE As Single
Public HORZRES As Single
Public VERTRES As Single
Public LOGPIXELSX As Single
Public LOGPIXELSY As Single
Public PHYSICALWIDTH As Single
Public PHYSICALHEIGHT As Single
Public PHYSICALOFFSETX As Single
Public PHYSICALOFFSETY As Single

Public Const SWP_NOMOVE = &H2
Public Const SWP_NOSIZE = &H1
Public Const AppName = "Adra"

#If Win32 Then
    Declare Function GetDeviceCaps Lib "gdi32" (ByVal hdc As Long, ByVal nIndex As Long) As Long
    Public Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" _
        (ByVal hWnd As Long, ByVal lpOperation As String, ByVal lpFile As String, _
        ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long
    Public Declare Function SetWindowPos Lib "user32" (ByVal hWnd As Long, ByVal hWndInsertAfter As Long, ByVal X As Long, ByVal Y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long

#Else
    Declare Function GetDeviceCaps Lib "GDI" (ByVal hdc As Integer, ByVal nIndex As Integer) As Integer
    Public Declare Function ShellExecute Lib "shell.dll" (ByVal _
        hWnd As Integer, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters _
        As String, ByVal lpDirectory As String, ByVal nShowCmd As Integer) As Integer
    Public Declare Sub SetWindowPos Lib "User" (ByVal hWnd As Integer, ByVal hWndInsertAfter As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal cx As Integer, ByVal cy As Integer, ByVal wFlags As Integer)
#End If


Public Sub GetDruckerVariabeln()
    HORZSIZE = GetDeviceCaps(Printer.hdc, 4)          'HORZSIZE        Width, in millimeters, of the physical screen.
    VERTSIZE = GetDeviceCaps(Printer.hdc, 6)          'VERTSIZE        Height, in millimeters, of the physical screen.
    HORZRES = GetDeviceCaps(Printer.hdc, 8)           'HORZRES         Width, in pixels, of the screen.
    VERTRES = GetDeviceCaps(Printer.hdc, 10)          'VERTRES         Height, in raster lines, of the screen.
    LOGPIXELSX = GetDeviceCaps(Printer.hdc, 88)       'LOGPIXELSX      Number of pixels per logical inch along the screen width.
    LOGPIXELSY = GetDeviceCaps(Printer.hdc, 90)       'LOGPIXELSY      Number of pixels per logical inch along the screen height.
    PHYSICALWIDTH = GetDeviceCaps(Printer.hdc, 110)   'PHYSICALWIDTH   For printing devices: the width of the physical page, in _
                                                                       device units. For example, a printer set to print at 600 dpi _
                                                                       on 8.5"x11" paper has a physical width value of 5100 device units. _
                                                                       Note that the physical page is almost always greater than the _
                                                                       printable area of the page, and never smaller.
    PHYSICALHEIGHT = GetDeviceCaps(Printer.hdc, 111)  'PHYSICALHEIGHT  For printing devices: the height of the physical page, in _
                                                                       device units. For example, a printer set to print at 600 dpi _
                                                                       on 8.5"x11" paper has a physical height value of 6600 device units. _
                                                                       Note that the physical page is almost always greater than the _
                                                                       printable area of the page, and never smaller.
    PHYSICALOFFSETX = GetDeviceCaps(Printer.hdc, 112) 'PHYSICALOFFSETX For printing devices: the distance from the left edge of _
                                                                       the physical page to the left edge of the printable area, in device units. _
                                                                       For example, a printer set to print at 600 dpi on 8.5"x11" paper, _
                                                                       that cannot print on the leftmost 0.25" of paper, has a horizontal _
                                                                       physical offset of 150 device units.
    PHYSICALOFFSETY = GetDeviceCaps(Printer.hdc, 113) 'PHYSICALOFFSETY For printing devices: the distance from the top edge of the physical _
                                                                       page to the top edge of the printable area, in device units. _
                                                                       For example, a printer set to print at 600 dpi on 8.5"x11" paper, _
                                                                       that cannot print on the topmost 0.5" of paper, has a vertical _
                                                                       physical offset of 300 device units.
End Sub


Sub main()
    On Error GoTo Fehler
    Info.B_OK.Visible = False
    Info.Show
    DoEvents
    Call GetDruckerVariabeln
    Eingabe.Show
    Unload Info
    Exit Sub
Fehler:
    Select Case Err
        Case Else
            MsgBox "Fehler: " + Str$(Err) + " : " + Error$
    End Select
    Resume Next
End Sub


Public Sub DruckerEinrichten()
    On Error GoTo Fehler
    'Eingabe.CMDialog.Flags = 64
    'Eingabe.CMDialog.PrinterDefault = True
    'Eingabe.CMDialog.Action = 5
    
    'Druckerauswahl.Show 1
    
    GetDruckerVariabeln
    Exit Sub
Fehler:
    Select Case Err
        Case 32755 'Abbruch gedrckt
        Case Else
            MsgBox "Fehler: " + Str$(Err) + " : " + Error$
    End Select
    Resume Next
End Sub


Public Sub Get_mnuSelect(Schlssel As String, f As Form)
    For a = 0 To 3
        If GetSetting(AppName, Schlssel, Str$(a), "") <> "" Then
            f.mnuSelect(a).Caption = GetSetting(AppName, Schlssel, Str$(a), "")
            f.mnuSelect(a).Visible = True
        End If
    Next a
End Sub

Public Sub BVAktualisieren()
    On Error GoTo Fehler
    Dim BVNr(500) As Long
    Dim a As Integer
    Dim lf As Integer
    lf = 0
    While Not Eingabe.Data7.Recordset.EOF
        lf = lf + 1
        BVNr(lf) = Eingabe.Data7.Recordset("BVLFNR")
        Eingabe.Data7.Recordset.MoveNext
    Wend
    Dim SqlText As String
    
    If lf = 0 Then
        SqlText = " Select * from BVEingabe where LFNR = 0"
    Else
        SqlText = " Select * from BVEingabe"
    End If
    For a = 1 To lf
        If a = 1 Then SqlText = " Select * from BVEingabe where "
        If a = lf Then
            SqlText = SqlText + "LFNR = " + Trim$(Str$(BVNr(a)))
        Else
            SqlText = SqlText + "LFNR = " + Trim$(Str$(BVNr(a))) + " or "
        End If
    Next a
    Eingabe.Data8.RecordSource = SqlText
    Eingabe.Data8.Refresh
    Exit Sub
Fehler:
    Select Case Err
        Case Else
            MsgBox "Fehler: " + Str$(Err) + " : " + Error$
    End Select
    Resume Next
End Sub




Public Sub KopiereAdresseinDB(DBextern As String, DBintern As String, LFNR As Long)
    'On Error GoTo fehler
    Dim DBext As Database 'externe Datenbank
    Dim DBint As Database 'aktuell geffnete datenbank
    
    Dim T1int As Recordset
    Dim T2int As Recordset
    Dim T1ext As Table
    Dim T2ext As Table
    Dim LFNRkopie As Long
    
    Set DBext = OpenDatabase(DBextern)
    Set DBint = DBEngine.Workspaces(0).OpenDatabase(DBintern)
    Set T1ext = DBext.OpenTable("Adress")
    Set T1int = DBint.OpenRecordset("Select * from Adress where LFNR = " + Trim$(Str$(LFNR)), dbOpenDynaset)
        
        T1ext.AddNew
        T1ext("AdressTyp") = T1int("AdressTyp")
        T1ext("Erstelltam") = T1int("Erstelltam")
        T1ext("Letztenderung") = T1int("Letztenderung")
        T1ext("Kundennummer") = T1int("Kundennummer")
        T1ext("Kategorie") = T1int("Kategorie")
        T1ext("Firma") = T1int("Firma")
        T1ext("Firma2") = T1int("Firma2")
        T1ext("Abteilung") = T1int("Abteilung")
        T1ext("zuHnden") = T1int("zuHnden")
        T1ext("Briefanrede") = T1int("Briefanrede")
        T1ext("Anrede") = T1int("Anrede")
        T1ext("Titel") = T1int("Titel")
        T1ext("Name") = T1int("Name")
        T1ext("Vorname") = T1int("Vorname")
        T1ext("Strae") = T1int("Strae")
        T1ext("Land") = T1int("Land")
        T1ext("PLZ") = T1int("PLZ")
        T1ext("Ort") = T1int("Ort")
        T1ext("PFLZ") = T1int("PFLZ")
        T1ext("Postfach") = T1int("Postfach")
        T1ext("Staat") = T1int("Staat")
        T1ext("Geburtstag") = T1int("Geburtstag")
        T1ext("Beruf") = T1int("Beruf")
        T1ext("Telefon") = T1int("Telefon")
        T1ext("Telefax") = T1int("Telefax")
        T1ext("Memo") = T1int("Memo")
        T1ext("Frei1") = T1int("Frei1")
        T1ext("Frei2") = T1int("Frei2")
        T1ext("Frei3") = T1int("Frei3")
        T1ext("Frei4") = T1int("Frei4")
        T1ext("Frei5") = T1int("Frei5")
        T1ext("Frei6") = T1int("Frei6")
        T1ext("Frei7") = T1int("Frei7")
        T1ext("Frei8") = T1int("Frei8")
        T1ext("Frei9") = T1int("Frei9")
        T1ext.Update
        T1ext.MoveLast
        LFNRkopie = T1ext("LFNR")
        Set T2ext = DBext.OpenTable("Bank")
        Set T2int = DBint.OpenRecordset("Select * from Bank where Nr = " + Str$(T1int("LFNR")), dbOpenDynaset)
            While Not T2int.EOF
                T2ext.AddNew
                T2ext("Nr") = T1ext("LFNR")
                T2ext("Nummer") = T2int("Nummer")
                T2ext("Bankleitzahl") = T2int("Bankleitzahl")
                T2ext("Bank") = T2int("Bank")
                T2ext("Memo") = T2int("Memo")
                T2ext.Update
                T2int.MoveNext
            Wend
        T2ext.Close
        T2int.Close
        Set T2ext = DBext.OpenTable("Bemerkungen")
        Set T2int = DBint.OpenRecordset("Select * from Bemerkungen where Nr = " + Str$(T1int("LFNR")), dbOpenDynaset)
            While Not T2int.EOF
                T2ext.AddNew
                T2ext("Nr") = T1ext("LFNR")
                T2ext("Kurzbemerkung") = T2int("Kurzbemerkung")
                T2ext("Memo") = T2int("Memo")
                T2ext.Update
                T2int.MoveNext
            Wend
        T2ext.Close
        T2int.Close
        Set T2ext = DBext.OpenTable("Dateien")
        Set T2int = DBint.OpenRecordset("Select * from Dateien where Nr = " + Str$(T1int("LFNR")), dbOpenDynaset)
            While Not T2int.EOF
                T2ext.AddNew
                T2ext("Nr") = T1ext("LFNR")
                T2ext("Datei") = T2int("Datei")
                T2ext("Memo") = T2int("Memo")
                T2ext.Update
                T2int.MoveNext
            Wend
        T2ext.Close
        T2int.Close
        Set T2ext = DBext.OpenTable("Telefon")
        Set T2int = DBint.OpenRecordset("Select * from Telefon where Nr = " + Str$(T1int("LFNR")), dbOpenDynaset)
            While Not T2int.EOF
                T2ext.AddNew
                T2ext("Nr") = T1ext("LFNR")
                T2ext("Telefonnummer") = T2int("Telefonnummer")
                T2ext("Ansprechpartner") = T2int("Ansprechpartner")
                T2ext("Memo") = T2int("Memo")
                T2ext.Update
                T2int.MoveNext
            Wend
        
    T1ext.Close
    T1int.Close
    DBext.Close
    DBint.Close
    Exit Sub
Fehler:
    Select Case Err
        Case 3343 'Falsches Datenbankformat
            MsgBox "Datenbank hat ein falsches Datenbankformat.", vbInformation
            Exit Sub
        Case Else
            MsgBox "Fehler: +" + Str$(Err) + ", " + Error$, vbInformation
    End Select
    Resume Next
End Sub

Public Sub Add_mnuSelect(FName As String, fr As Form)
    Dim i%, C%
    If FName = App.Path + "\nochfrei" Then
        Exit Sub
    End If
    ReDim FileArray(4)
    FileArray(0) = FName
    For i% = 0 To 3
        FileArray(i + 1) = fr.mnuSelect(i%).Caption
    Next i%
    fr.mnuSelect(0).Caption = FileArray(0)
    C% = 1
    For i% = 1 To 3
        If FileArray(i%) <> FileArray(0) Then
            fr.mnuSelect(C%).Caption = FileArray(i%)
            C% = C% + 1
        End If
    Next i%
    For i% = 0 To 3
        If fr.mnuSelect(i%).Caption > "" Then
            fr.mnuSelect(i%).Visible = True
        End If
    Next i%
End Sub




Public Sub DatabankAnlegen(Datei As String) 'Legt eine Neue Adra Datenbank an
    Dim DB As Database
    Dim T As Table
    On Error GoTo Fehler
    CancelOP = True
    Dim NewTd0 As New TableDef, NewTd1 As New TableDef, NewTd2 As New TableDef, NewTd3 As New TableDef, NewTd4 As New TableDef
    Dim NewTd5 As New TableDef, NewTd6 As New TableDef, NewTd7 As New TableDef, NewTd8 As New TableDef
    Dim NewTd9 As New TableDef, NewTd10 As New TableDef, NewTd11 As New TableDef
    Dim F0 As New Field, F1 As New Field, F2 As New Field, F3 As New Field, F4 As New Field, F5 As New Field
    Dim F6 As New Field, F7 As New Field, F8 As New Field, F9 As New Field, F10 As New Field
    Dim F11 As New Field, F12 As New Field, F13 As New Field, F14 As New Field, F15 As New Field
    Dim F16 As New Field, F17 As New Field, F17_1 As New Field, F18 As New Field, F19 As New Field, F20 As New Field
    Dim F21 As New Field, F22 As New Field, F23 As New Field, F24 As New Field, F25 As New Field
    Dim F26 As New Field, F27 As New Field, F28 As New Field, F29 As New Field, F30 As New Field
    Dim F31 As New Field, F32 As New Field, F33 As New Field, F34 As New Field

    Dim F100 As New Field, F101 As New Field, F102 As New Field, F103 As New Field, F104 As New Field 'Bank
    Dim F200 As New Field, F201 As New Field, F202 As New Field 'Bemerkungen
    Dim F300 As New Field 'Kategorie
    Dim F400 As New Field, F401 As New Field, F402 As New Field 'Dateien
    Dim F500 As New Field, F501 As New Field, F502 As New Field, F503 As New Field 'Telefon
    
    Dim F600 As New Field, F601 As New Field, F602 As New Field, F603 As New Field, F604 As New Field, F605 As New Field 'Freie Bauvorhabenfelde
    Dim F606 As New Field, F607 As New Field, F608 As New Field, F609 As New Field, F610 As New Field, F611 As New Field
    Dim F612 As New Field, F613 As New Field, F614 As New Field
    
    Dim F700 As New Field, F701 As New Field, F702 As New Field, F703 As New Field, F704 As New Field, F705 As New Field
    Dim F706 As New Field, F707 As New Field, F708 As New Field, F709 As New Field, F710 As New Field, F711 As New Field
    Dim F712 As New Field, F713 As New Field, F714 As New Field, F715 As New Field, F716 As New Field, F717 As New Field
    Dim F718 As New Field, F719 As New Field, F720 As New Field, F721 As New Field, F722 As New Field, F723 As New Field
    Dim F724 As New Field, F725 As New Field, F726 As New Field, F727 As New Field, F728 As New Field, F729 As New Field
    Dim F730 As New Field, F731 As New Field, F732 As New Field, F733 As New Field
    
    Dim F800 As New Field, F801 As New Field, F802 As New Field, F803 As New Field
    
    Dim F900 As New Field, F901 As New Field, F902 As New Field, F903 As New Field, F904 As New Field
    Dim F905 As New Field, F906 As New Field, F907 As New Field, F908 As New Field
    
    Dim F1000 As New Field, F1001 As New Field, F1002 As New Field 'BVBemerkungen
    
    Dim F1100 As New Field, F1101 As New Field, F1102 As New Field 'DateienBV
    
    Set DB = CreateDatabase(Datei, ";LANGID=0x0809;CP=1252;COUNTRY=0", 3)
        If DB Is Nothing Then MsgBox "Kann keine Datenbank anlegen", vbInformation: Exit Sub
        NewTd0.Name = "Adress"
            F0.Name = "LFNR":              F0.Type = dbLong: F0.Attributes = 16:  NewTd0.Fields.Append F0
            F33.Name = "Erstelltam":       F33.Type = dbDate:                     NewTd0.Fields.Append F33
            F34.Name = "Letztenderung":   F34.Type = dbDate:                     NewTd0.Fields.Append F34
            F1.Name = "AdressTyp":         F1.Type = dbInteger:                   NewTd0.Fields.Append F1
            F2.Name = "Kundennummer":      F2.Type = dbText: F2.Size = 20:        NewTd0.Fields.Append F2
            F3.Name = "Kategorie":         F3.Type = dbText: F3.Size = 30:        NewTd0.Fields.Append F3
            F4.Name = "Firma":             F4.Type = dbText: F4.Size = 40:        NewTd0.Fields.Append F4
            F5.Name = "Firma2":            F5.Type = dbText: F5.Size = 40:        NewTd0.Fields.Append F5
            F6.Name = "Abteilung":         F6.Type = dbText: F6.Size = 40:        NewTd0.Fields.Append F6
            F7.Name = "zuHnden":          F7.Type = dbText: F7.Size = 40:        NewTd0.Fields.Append F7
            F8.Name = "Briefanrede":       F8.Type = dbText: F8.Size = 40:        NewTd0.Fields.Append F8
            F9.Name = "Anrede":            F9.Type = dbText: F9.Size = 20:        NewTd0.Fields.Append F9
            F10.Name = "Titel":            F10.Type = dbText: F10.Size = 20:      NewTd0.Fields.Append F10
            F11.Name = "Name":             F11.Type = dbText: F11.Size = 25:      NewTd0.Fields.Append F11
            F12.Name = "Vorname":          F12.Type = dbText: F12.Size = 25:      NewTd0.Fields.Append F12
            F13.Name = "Strae":           F13.Type = dbText: F13.Size = 40:      NewTd0.Fields.Append F13
            F14.Name = "Land":             F14.Type = dbText: F14.Size = 5:       NewTd0.Fields.Append F14
            F15.Name = "PLZ":              F15.Type = dbText: F15.Size = 10:      NewTd0.Fields.Append F15
            F16.Name = "Ort":              F16.Type = dbText: F16.Size = 40:      NewTd0.Fields.Append F16
            F17_1.Name = "PFLZ":           F17_1.Type = dbText: F17_1.Size = 6:   NewTd0.Fields.Append F17_1
            F17.Name = "Postfach":         F17.Type = dbText: F17.Size = 10:      NewTd0.Fields.Append F17
            F18.Name = "Staat":            F18.Type = dbText: F18.Size = 30:      NewTd0.Fields.Append F18
            F19.Name = "Geburtstag":       F19.Type = dbText: F19.Size = 10:      NewTd0.Fields.Append F19
            F20.Name = "Beruf":            F20.Type = dbText: F20.Size = 40:      NewTd0.Fields.Append F20
            F21.Name = "Telefon":          F21.Type = dbText: F21.Size = 25:      NewTd0.Fields.Append F21
            F22.Name = "Telefax":          F22.Type = dbText: F22.Size = 25:      NewTd0.Fields.Append F22
            F23.Name = "Memo":             F23.Type = dbMemo:                     NewTd0.Fields.Append F23
            F24.Name = "Frei1":            F24.Type = dbText: F24.Size = 60:      NewTd0.Fields.Append F24
            F25.Name = "Frei2":            F25.Type = dbText: F25.Size = 60:      NewTd0.Fields.Append F25
            F26.Name = "Frei3":            F26.Type = dbText: F26.Size = 60:      NewTd0.Fields.Append F26
            F27.Name = "Frei4":            F27.Type = dbText: F27.Size = 60:      NewTd0.Fields.Append F27
            F28.Name = "Frei5":            F28.Type = dbText: F28.Size = 60:      NewTd0.Fields.Append F28
            F29.Name = "Frei6":            F29.Type = dbText: F29.Size = 60:      NewTd0.Fields.Append F29
            F30.Name = "Frei7":            F30.Type = dbText: F30.Size = 60:      NewTd0.Fields.Append F30
            F31.Name = "Frei8":            F31.Type = dbText: F31.Size = 60:      NewTd0.Fields.Append F31
            F32.Name = "Frei9":            F32.Type = dbText: F32.Size = 60:      NewTd0.Fields.Append F32
        DB.TableDefs.Append NewTd0
        
        NewTd1.Name = "Bank"
            F100.Name = "Nr":              F100.Type = dbLong:                    NewTd1.Fields.Append F100
            F101.Name = "Nummer":          F101.Type = dbText: F101.Size = 15:    NewTd1.Fields.Append F101
            F102.Name = "Bankleitzahl":    F102.Type = dbText: F102.Size = 15:    NewTd1.Fields.Append F102
            F103.Name = "Bank":            F103.Type = dbText: F103.Size = 30:    NewTd1.Fields.Append F103
            F104.Name = "Memo":            F104.Type = dbMemo:                    NewTd1.Fields.Append F104
        DB.TableDefs.Append NewTd1
        
        NewTd2.Name = "Bemerkungen"
            F200.Name = "Nr":              F200.Type = dbLong:                    NewTd2.Fields.Append F200
            F201.Name = "Kurzbemerkung":   F201.Type = dbText: F201.Size = 30:    NewTd2.Fields.Append F201
            F202.Name = "Memo":            F202.Type = dbMemo:                    NewTd2.Fields.Append F202
        DB.TableDefs.Append NewTd2
        
        NewTd3.Name = "Kategorie"
            F300.Name = "Kategorie":       F300.Type = dbText: F300.Size = 30:    NewTd3.Fields.Append F300
        DB.TableDefs.Append NewTd3
        
        NewTd4.Name = "Dateien"
            F400.Name = "Nr":              F400.Type = dbLong:                    NewTd4.Fields.Append F400
            F401.Name = "Datei":           F401.Type = dbText: F401.Size = 100:   NewTd4.Fields.Append F401
            F402.Name = "Memo":            F402.Type = dbMemo:                    NewTd4.Fields.Append F402
        DB.TableDefs.Append NewTd4
        
        NewTd5.Name = "Telefon"
            F500.Name = "Nr":              F500.Type = dbLong:                    NewTd5.Fields.Append F500
            F501.Name = "Telefonnummer":   F501.Type = dbText: F501.Size = 20:    NewTd5.Fields.Append F501
            F502.Name = "Ansprechpartner": F502.Type = dbText: F502.Size = 30:    NewTd5.Fields.Append F502
            F503.Name = "Memo":            F503.Type = dbMemo:                    NewTd5.Fields.Append F503
        DB.TableDefs.Append NewTd5
            
        NewTd6.Name = "FreieFelderBV"
            F600.Name = "Frei0":           F600.Type = dbText: F600.Size = 20:    NewTd6.Fields.Append F600
            F601.Name = "Frei1":           F601.Type = dbText: F601.Size = 20:    NewTd6.Fields.Append F601
            F602.Name = "Frei2":           F602.Type = dbText: F602.Size = 20:    NewTd6.Fields.Append F602
            F603.Name = "Frei3":           F603.Type = dbText: F603.Size = 20:    NewTd6.Fields.Append F603
            F604.Name = "Frei4":           F604.Type = dbText: F604.Size = 20:    NewTd6.Fields.Append F604
            F605.Name = "Frei5":           F605.Type = dbText: F605.Size = 20:    NewTd6.Fields.Append F605
            F606.Name = "Frei6":           F606.Type = dbText: F606.Size = 20:    NewTd6.Fields.Append F606
            F607.Name = "Frei7":           F607.Type = dbText: F607.Size = 20:    NewTd6.Fields.Append F607
            F608.Name = "Frei8":           F608.Type = dbText: F608.Size = 20:    NewTd6.Fields.Append F608
            F609.Name = "Frei9":           F609.Type = dbText: F609.Size = 20:    NewTd6.Fields.Append F609
            F610.Name = "Frei10":          F610.Type = dbText: F610.Size = 20:    NewTd6.Fields.Append F610
            F611.Name = "Frei11":          F611.Type = dbText: F611.Size = 20:    NewTd6.Fields.Append F611
            F612.Name = "Frei12":          F612.Type = dbText: F612.Size = 20:    NewTd6.Fields.Append F612
            F613.Name = "Frei13":          F613.Type = dbText: F613.Size = 20:    NewTd6.Fields.Append F613
            F614.Name = "Frei14":          F614.Type = dbText: F614.Size = 20:    NewTd6.Fields.Append F614
        DB.TableDefs.Append NewTd6
            
        NewTd7.Name = "BVEingabe"
            F700.Name = "LFNR":             F700.Type = dbLong: F700.Attributes = 16: NewTd7.Fields.Append F700
            F701.Name = "Bauvorhaben":      F701.Type = dbText: F701.Size = 80:       NewTd7.Fields.Append F701
            F702.Name = "Bauherr":          F702.Type = dbText: F702.Size = 60:       NewTd7.Fields.Append F702
            F703.Name = "Bauwerk":          F703.Type = dbText: F703.Size = 60:       NewTd7.Fields.Append F703
            F704.Name = "Bauort":           F704.Type = dbText: F704.Size = 60:       NewTd7.Fields.Append F704
            F705.Name = "Baujahr":          F705.Type = dbText: F705.Size = 10:       NewTd7.Fields.Append F705
            F706.Name = "Auftragnr":        F706.Type = dbText: F706.Size = 10:       NewTd7.Fields.Append F706
            F707.Name = "BA":               F707.Type = dbText: F707.Size = 10:       NewTd7.Fields.Append F707
            F708.Name = "Fertigteilnr":     F708.Type = dbText: F708.Size = 10:       NewTd7.Fields.Append F708
            F709.Name = "Ortbetonnr":       F709.Type = dbText: F709.Size = 10:       NewTd7.Fields.Append F709
            F710.Name = "Baubeschreibung":  F710.Type = dbMemo:                       NewTd7.Fields.Append F710
            F711.Name = "Bemerkung":        F711.Type = dbMemo:                       NewTd7.Fields.Append F711
            F712.Name = "Geschftsleitung": F712.Type = dbText: F712.Size = 60:      NewTd7.Fields.Append F712
            F713.Name = "Schlsselfertig":  F713.Type = dbText:  F713.Size = 60:      NewTd7.Fields.Append F713
            F714.Name = "Architekt":        F714.Type = dbText:  F714.Size = 60:      NewTd7.Fields.Append F714
            F715.Name = "Statiker":         F715.Type = dbText:  F715.Size = 60:      NewTd7.Fields.Append F715
            F716.Name = "PrfStatiker":     F716.Type = dbText:  F716.Size = 60:      NewTd7.Fields.Append F716
            F717.Name = "Bauleiter":        F717.Type = dbText:  F717.Size = 60:      NewTd7.Fields.Append F717
            F718.Name = "Zeichengruppe":    F718.Type = dbText:  F718.Size = 60:      NewTd7.Fields.Append F718
            F719.Name = "Frei0":            F719.Type = dbText:  F719.Size = 40:      NewTd7.Fields.Append F719
            F720.Name = "Frei1":            F720.Type = dbText:  F720.Size = 40:      NewTd7.Fields.Append F720
            F721.Name = "Frei2":            F721.Type = dbText:  F721.Size = 40:      NewTd7.Fields.Append F721
            F722.Name = "Frei3":            F722.Type = dbText:  F722.Size = 40:      NewTd7.Fields.Append F722
            F723.Name = "Frei4":            F723.Type = dbText:  F723.Size = 40:      NewTd7.Fields.Append F723
            F724.Name = "Frei5":            F724.Type = dbText:  F724.Size = 40:      NewTd7.Fields.Append F724
            F725.Name = "Frei6":            F725.Type = dbText:  F725.Size = 40:      NewTd7.Fields.Append F725
            F726.Name = "Frei7":            F726.Type = dbText:  F726.Size = 40:      NewTd7.Fields.Append F726
            F727.Name = "Frei8":            F727.Type = dbText:  F727.Size = 40:      NewTd7.Fields.Append F727
            F728.Name = "Frei9":            F728.Type = dbText:  F728.Size = 40:      NewTd7.Fields.Append F728
            F729.Name = "Frei10":           F729.Type = dbText:  F729.Size = 40:      NewTd7.Fields.Append F729
            F730.Name = "Frei11":           F730.Type = dbText:  F730.Size = 40:      NewTd7.Fields.Append F730
            F731.Name = "Frei12":           F731.Type = dbText:  F731.Size = 40:      NewTd7.Fields.Append F731
            F732.Name = "Frei13":           F732.Type = dbText:  F732.Size = 40:      NewTd7.Fields.Append F732
            F733.Name = "Frei14":           F733.Type = dbText:  F733.Size = 40:      NewTd7.Fields.Append F733
        DB.TableDefs.Append NewTd7
        
        NewTd8.Name = "Bauvorhaben"
            F800.Name = "Nr":              F800.Type = dbLong:                    NewTd8.Fields.Append F800
            F801.Name = "BVLFNR":          F801.Type = dbLong:                    NewTd8.Fields.Append F801
            F802.Name = "Funktion":        F802.Type = dbText: F802.Size = 30:    NewTd8.Fields.Append F802
            F803.Name = "Memo":            F803.Type = dbMemo:                    NewTd8.Fields.Append F803
        DB.TableDefs.Append NewTd8
        
        NewTd9.Name = "FreieFelder"
            F900.Name = "Frei0":           F900.Type = dbText: F900.Size = 20:    NewTd9.Fields.Append F900
            F901.Name = "Frei1":           F901.Type = dbText: F901.Size = 20:    NewTd9.Fields.Append F901
            F902.Name = "Frei2":           F902.Type = dbText: F902.Size = 20:    NewTd9.Fields.Append F902
            F903.Name = "Frei3":           F903.Type = dbText: F903.Size = 20:    NewTd9.Fields.Append F903
            F904.Name = "Frei4":           F904.Type = dbText: F904.Size = 20:    NewTd9.Fields.Append F904
            F905.Name = "Frei5":           F905.Type = dbText: F905.Size = 20:    NewTd9.Fields.Append F905
            F906.Name = "Frei6":           F906.Type = dbText: F906.Size = 20:    NewTd9.Fields.Append F906
            F907.Name = "Frei7":           F907.Type = dbText: F907.Size = 20:    NewTd9.Fields.Append F907
            F908.Name = "Frei8":           F908.Type = dbText: F908.Size = 20:    NewTd9.Fields.Append F908
        DB.TableDefs.Append NewTd9
        
        NewTd10.Name = "BVBemerkungen"
            F1000.Name = "Nr":             F1000.Type = dbLong:                   NewTd10.Fields.Append F1000
            F1001.Name = "Kurzbemerkung":  F1001.Type = dbText: F1001.Size = 30:  NewTd10.Fields.Append F1001
            F1002.Name = "Memo":           F1002.Type = dbMemo:                   NewTd10.Fields.Append F1002
        DB.TableDefs.Append NewTd10
        
        NewTd11.Name = "DateienBV"
            F1100.Name = "Nr":              F1100.Type = dbLong:                    NewTd11.Fields.Append F1100
            F1101.Name = "Datei":           F1101.Type = dbText: F1101.Size = 100:  NewTd11.Fields.Append F1101
            F1102.Name = "Memo":            F1102.Type = dbMemo:                    NewTd11.Fields.Append F1102
        DB.TableDefs.Append NewTd11
    DB.Close
    
    Set DB = OpenDatabase(Datei)
    Set T = DB.OpenTable("FreieFelder")
    T.AddNew
    T("Frei0") = "Frei"
    T("Frei1") = "Frei"
    T("Frei2") = "Frei"
    T("Frei3") = "Frei"
    T("Frei4") = "Frei"
    T("Frei5") = "Frei"
    T("Frei6") = "Frei"
    T("Frei7") = "Frei"
    T("Frei8") = "Frei"
    T.Update
    T.Close
    DB.Close
    
    Set DB = OpenDatabase(Datei)
    Set T = DB.OpenTable("FreieFelderBV")
    T.AddNew
    T("Frei0") = "Frei"
    T("Frei1") = "Frei"
    T("Frei2") = "Frei"
    T("Frei3") = "Frei"
    T("Frei4") = "Frei"
    T("Frei5") = "Frei"
    T("Frei6") = "Frei"
    T("Frei7") = "Frei"
    T("Frei8") = "Frei"
    T("Frei9") = "Frei"
    T("Frei10") = "Frei"
    T("Frei11") = "Frei"
    T("Frei12") = "Frei"
    T("Frei13") = "Frei"
    T("Frei14") = "Frei"
    T.Update
    T.Close
    DB.Close
    
    CancelOP = False
    Exit Sub
Fehler:
    Select Case Err
        Case 3204
            MsgBox "Datenbank mit diesen Namen ist bereits vorhanden.", vbInformation
        Case 3196
            MsgBox "Datenbank mit diesen Namen ist bereits vorhanden und aktiv.", vbInformation
        Case 3044
            MsgBox "Datentrger ist schreibgeschtzt, oder falsche Pfad Angabe.", vbInformation
        Case Else
            MsgBox Str$(Err) + "  :" + Error$, vbInformation
    End Select
    CancelOP = True
    Unload MSG
    Exit Sub
    Resume Next
End Sub


Sub getini() 'Holt Programmvariablen aus der Registrierung
    StdMaske = GetSetting(AppName, "Maske", "StandartMaske", App.Path + "\adra.msk")
End Sub




Public Sub Save_mnuSelect(Schlssel As String, f As Form)
    For a = 0 To 3
       If f.mnuSelect(a).Caption > "" Then
          SaveSetting AppName, Schlssel, Str$(a), f.mnuSelect(a).Caption
       End If
    Next a
End Sub

Public Sub writeini() 'Schreibt Programmvariablen in die Registrierung
    SaveSetting AppName, "Datenbank", "Pfad", DatabasePath
    SaveSetting AppName, "Datenbank", "Sorierung", SortAdress
    SaveSetting AppName, "Maske", "StandartMaske", StdMaske
End Sub



Public Sub Schreibein(ctr As Control, typ As String, Leer As Integer)
    On Error GoTo Fehler
    
    ctr.Clear
    Dim DB As Database
    Dim T As Dynaset
    If Leer = True Then ctr.AddItem ""
    Set DB = OpenDatabase(DatabasePath)
    Set T = DB.CreateDynaset(typ)
    While Not T.EOF
        If VarType(T(typ)) = 8 Then
            ctr.AddItem T(typ)
        End If
        T.MoveNext
    Wend
    T.Close
    DB.Close
    
    Exit Sub
Fehler:
    Select Case Err
        Case Else
            MsgBox "Fehler: " + Str$(Err) + " : " + Error$
    End Select
    Resume Next

End Sub


Public Function MaskeExport(MaskPfad As String, f As Control) As String
    On Error GoTo Fehler
    Dim alle As String
    Dim free As Integer
    Dim DBFeld As String
    If Trim$(MaskPfad) = "" Then
        MsgBox "Es ist keine Standartexportmaske definiert.", vbInformation
        Screen.MousePointer = 0
        Exit Function
    End If
    alle = ""
    free = FreeFile
    Open (MaskPfad) For Random As free Len = Len(MSK)
    For a = 1 To (LOF(free) / Len(MSK))
        Get free, a, MSK
        If Left$(Trim$(MSK.MSK), 1) = "<" And Right$(Trim$(MSK.MSK), 1) = ">" Then
            If Left$(Trim$(MSK.MSK), 5) = "<Frei" Then
                DBFeld = Left$(Trim$(MSK.MSK), 6)
                DBFeld = Right$(DBFeld, 5)
                If VarType(f.Recordset(DBFeld)) = 8 Then
                    alle = alle + f.Recordset(DBFeld)
                End If
                If VarType(f.Recordset(DBFeld)) = 7 Then
                    alle = alle + Format$(f.Recordset(DBFeld), "ddddd")
                End If
            Else
                DBFeld = Right$(Left$(Trim$(MSK.MSK), Len(Trim$(MSK.MSK)) - 1), Len(Trim$(MSK.MSK)) - 2)
                If VarType(f.Recordset(DBFeld)) = 8 Then
                    alle = alle + f.Recordset(DBFeld)
                End If
            End If
        ElseIf Trim$(MSK.MSK) = "(Leerzeichen)" Then
            alle = alle + " "
        ElseIf Trim$(MSK.MSK) = "(Return)" Then
            alle = alle + Chr$(13) + Chr$(10)
        ElseIf Trim$(MSK.MSK) = "(Tabulator)" Then
            alle = alle + Chr$(9)
        ElseIf Trim$(MSK.MSK) = "(Komma)" Then
            alle = alle + ","
        ElseIf Trim$(MSK.MSK) = "(Strichpunkt)" Then
            alle = alle + ";"
        ElseIf Trim$(MSK.MSK) = "(Punkt)" Then
            alle = alle + "."
        ElseIf Trim$(MSK.MSK) = "(Doppelpunkt)" Then
            alle = alle + ":"
        ElseIf Trim$(MSK.MSK) = "(Lattenzaun)" Then
            alle = alle + "#"
        ElseIf Trim$(MSK.MSK) = "(Pipe)" Then
            alle = alle + "|"
        ElseIf Trim$(MSK.MSK) = "(Bindestrich)" Then
            alle = alle + "-"
        End If
    Next a
    Close free
    MaskeExport = alle
    Exit Function
Fehler:
    Select Case Err
        Case Else
            MsgBox "Fehler: " + Str$(Err) + " : " + Error$, vbInformation
    End Select
    Resume Next
End Function




